/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotatedJavaCodeReferenceElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.cache.TypeAnnotationContainer;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsReferenceParameterListImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsJavaCodeReferenceElementImpl
extends ClsElementImpl
implements PsiAnnotatedJavaCodeReferenceElement {
    private final PsiElement myParent;
    private final String myCanonicalText;
    private String myShortName;
    private final String myQualifiedName;
    private final PsiReferenceParameterList myRefParameterList;
    private final TypeAnnotationContainer myAnnotations;
    private final ClsJavaCodeReferenceElementImpl myQualifier;

    public ClsJavaCodeReferenceElementImpl(@NotNull PsiElement parent, @NotNull String canonicalText) {
        if (parent == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(0);
        }
        if (canonicalText == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(1);
        }
        this(parent, canonicalText, TypeAnnotationContainer.EMPTY);
    }

    public ClsJavaCodeReferenceElementImpl(@NotNull PsiElement parent, @NotNull String canonicalText, @NotNull TypeAnnotationContainer annotations) {
        String canonical;
        if (parent == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(2);
        }
        if (canonicalText == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(3);
        }
        if (annotations == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(4);
        }
        this.myParent = parent;
        this.myCanonicalText = canonical = TypeInfo.internFrequentType(canonicalText);
        String qName = TypeInfo.internFrequentType(PsiNameHelper.getQualifiedClassName(this.myCanonicalText, false));
        this.myQualifiedName = qName.equals(canonical) ? canonical : qName;
        String[] classParameters = PsiNameHelper.getClassParametersText(canonicalText);
        this.myRefParameterList = classParameters.length == 0 ? null : new ClsReferenceParameterListImpl((PsiElement)this, classParameters, annotations);
        this.myAnnotations = annotations;
        String prefix = PsiNameHelper.getOuterClassReference(canonicalText);
        TypeAnnotationContainer container = prefix.isEmpty() ? TypeAnnotationContainer.EMPTY : annotations.forEnclosingClass();
        this.myQualifier = container == TypeAnnotationContainer.EMPTY ? null : new ClsJavaCodeReferenceElementImpl((PsiElement)this, prefix, container);
    }

    public PsiElement @NotNull [] getChildren() {
        PsiElement[] psiElementArray;
        if (this.myQualifier != null) {
            PsiElement[] psiElementArray2;
            if (this.myRefParameterList != null) {
                PsiElement[] psiElementArray3 = new PsiElement[2];
                psiElementArray3[0] = this.myQualifier;
                psiElementArray2 = psiElementArray3;
                psiElementArray3[1] = this.myRefParameterList;
            } else {
                PsiElement[] psiElementArray4 = new PsiElement[1];
                psiElementArray2 = psiElementArray4;
                psiElementArray4[0] = this.myQualifier;
            }
            if (psiElementArray2 == null) {
                ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(5);
            }
            return psiElementArray2;
        }
        if (this.myRefParameterList != null) {
            PsiElement[] psiElementArray5 = new PsiElement[1];
            psiElementArray = psiElementArray5;
            psiElementArray5[0] = this.myRefParameterList;
        } else {
            psiElementArray = PsiElement.EMPTY_ARRAY;
        }
        if (psiElementArray == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(6);
        }
        return psiElementArray;
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public String getText() {
        return PsiNameHelper.getPresentableText(this);
    }

    @Override
    public int getTextLength() {
        return this.getText().length();
    }

    public PsiReference getReference() {
        return this;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myCanonicalText;
        if (string == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated, PsiAnnotation @Nullable [] annotations) {
        String text = this.getCanonicalText();
        if (!annotated) {
            String string = text;
            if (string == null) {
                ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(8);
            }
            return string;
        }
        StringBuilder sb = new StringBuilder();
        String prefix = PsiNameHelper.getOuterClassReference(text);
        int simpleNamePos = 0;
        if (!StringUtil.isEmpty((String)prefix)) {
            if (this.myQualifier != null) {
                sb.append(this.myQualifier.getCanonicalText(true, this.myQualifier.myAnnotations.getProvider((PsiElement)this.myQualifier).getAnnotations()));
            } else {
                sb.append(prefix);
            }
            sb.append('.');
            simpleNamePos = prefix.length() + 1;
        }
        PsiNameHelper.appendAnnotations(sb, annotations == null ? Collections.emptyList() : Arrays.asList(annotations), true);
        int typeArgPos = text.indexOf(60, simpleNamePos);
        if (typeArgPos == -1) {
            sb.append(text, simpleNamePos, text.length());
        } else {
            sb.append(text, simpleNamePos, typeArgPos);
            PsiNameHelper.appendTypeArgs(sb, this.getTypeParameters(), true, true);
        }
        String string = sb.toString();
        if (string == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    private JavaResolveResult advancedResolveImpl(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(10);
        }
        PsiTypeElement[] typeElements = this.myRefParameterList == null ? PsiTypeElement.EMPTY_ARRAY : this.myRefParameterList.getTypeParameterElements();
        PsiElement resolve = this.resolveElement(containingFile);
        if (resolve == null) {
            return null;
        }
        if (resolve instanceof PsiClass) {
            HashMap<PsiTypeParameter, PsiType> substitutionMap = new HashMap<PsiTypeParameter, PsiType>();
            int index = typeElements.length - 1;
            for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable((PsiClass)resolve)) {
                if (index < 0) {
                    substitutionMap.put(parameter, null);
                } else {
                    substitutionMap.put(parameter, typeElements[index].getType());
                }
                --index;
            }
            this.collectOuterClassTypeArgs((PsiClass)resolve, this.myCanonicalText, substitutionMap);
            return new CandidateInfo(resolve, PsiSubstitutor.createSubstitutor(substitutionMap));
        }
        return new CandidateInfo(resolve, PsiSubstitutor.EMPTY);
    }

    private void collectOuterClassTypeArgs(@NotNull PsiClass psiClass, String canonicalText, Map<PsiTypeParameter, PsiType> substitutionMap) {
        PsiClass containingClass;
        if (psiClass == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(11);
        }
        if ((containingClass = psiClass.getContainingClass()) != null) {
            String outerClassRef = PsiNameHelper.getOuterClassReference(canonicalText);
            String[] classParameters = PsiNameHelper.getClassParametersText(outerClassRef);
            PsiType[] args = classParameters.length == 0 ? null : new ClsReferenceParameterListImpl((PsiElement)this, classParameters, TypeAnnotationContainer.EMPTY).getTypeArguments();
            PsiTypeParameter[] typeParameters = containingClass.getTypeParameters();
            for (int i = 0; i < typeParameters.length; ++i) {
                if (args != null) {
                    if (i >= args.length) continue;
                    substitutionMap.put(typeParameters[i], args[i]);
                    continue;
                }
                substitutionMap.put(typeParameters[i], null);
            }
            if (!containingClass.hasModifierProperty("static")) {
                this.collectOuterClassTypeArgs(containingClass, outerClassRef, substitutionMap);
            }
        }
    }

    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        if (results.length == 1) {
            JavaResolveResult javaResolveResult = results[0];
            if (javaResolveResult == null) {
                ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(12);
            }
            return javaResolveResult;
        }
        JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(13);
        }
        return javaResolveResult;
    }

    @Override
    public JavaResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        PsiFile file = this.getContainingFile();
        if (file == null) {
            return this.diagnoseNoFile();
        }
        ResolveCache resolveCache = ResolveCache.getInstance((Project)file.getProject());
        ResolveResult[] results = resolveCache.resolveWithCaching((PsiPolyVariantReference)this, (ResolveCache.PolyVariantContextResolver)Resolver.INSTANCE, true, incompleteCode, file);
        if (results.length == 0) {
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(14);
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        JavaResolveResult[] javaResolveResultArray = (JavaResolveResult[])results;
        if (javaResolveResultArray == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(15);
        }
        return javaResolveResultArray;
    }

    private JavaResolveResult @NotNull [] diagnoseNoFile() {
        PsiElement root = (PsiElement)SyntaxTraverser.psiApi().parents((Object)this).last();
        PsiUtilCore.ensureValid((PsiElement)Objects.requireNonNull(root));
        throw new PsiInvalidElementAccessException((PsiElement)this, "parent=" + this.myParent + ", root=" + root + ", canonicalText=" + this.myCanonicalText);
    }

    public PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    @Nullable
    private PsiElement resolveElement(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(16);
        }
        for (PsiElement element = this.getParent(); element != null && !(element instanceof PsiFile); element = element.getParent()) {
            if (element instanceof PsiMethod) {
                for (PsiTypeParameter psiTypeParameter : PsiUtil.typeParametersIterable((PsiMethod)element)) {
                    if (!this.myQualifiedName.equals(psiTypeParameter.getName())) continue;
                    return psiTypeParameter;
                }
                continue;
            }
            if (!(element instanceof PsiClass) || element instanceof PsiTypeParameter) continue;
            PsiClass psiClass = (PsiClass)element;
            if (this.myQualifiedName.equals(psiClass.getQualifiedName())) {
                return element;
            }
            for (PsiTypeParameter parameter3 : PsiUtil.typeParametersIterable(psiClass)) {
                if (!this.myQualifiedName.equals(parameter3.getName())) continue;
                return parameter3;
            }
            for (PsiClass innerClass : psiClass.getInnerClasses()) {
                if (!this.myQualifiedName.equals(innerClass.getQualifiedName())) continue;
                return innerClass;
            }
        }
        Project project = containingFile.getProject();
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getInstance((Project)project).getResolveScope((PsiElement)this);
        return JavaPsiFacade.getInstance(project).findClass(this.myQualifiedName, globalSearchScope);
    }

    @Override
    public void processVariants(@NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(17);
        }
        throw new RuntimeException("Variants are not available for light references");
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return null;
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        return this.myRefParameterList;
    }

    @Override
    public String getQualifiedName() {
        return this.myQualifiedName;
    }

    public String getReferenceName() {
        String name = this.myShortName;
        if (name == null) {
            this.myShortName = name = PsiNameHelper.getShortClassName(this.myCanonicalText);
        }
        return name;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(18);
        }
        throw ClsJavaCodeReferenceElementImpl.cannotModifyException(this);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(19);
        }
        throw ClsJavaCodeReferenceElementImpl.cannotModifyException(this);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(20);
        }
        if (!(element instanceof PsiClass)) {
            return false;
        }
        PsiClass aClass = (PsiClass)element;
        return this.myCanonicalText.equals(aClass.getQualifiedName()) || this.getManager().areElementsEquivalent(this.resolve(), element);
    }

    public Object @NotNull [] getVariants() {
        throw new RuntimeException("Variants are not available for references to compiled code");
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(21);
        }
        buffer.append(this.getCanonicalText());
    }

    @Override
    protected void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(22);
        }
        this.setMirrorCheckingType(element, JavaElementType.JAVA_CODE_REFERENCE);
        PsiJavaCodeReferenceElement mirror = (PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)element);
        PsiReferenceParameterList list = this.getParameterList();
        if (list != null) {
            ClsJavaCodeReferenceElementImpl.setMirror(list, mirror.getParameterList());
        }
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(23);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceElement(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    @NotNull
    public PsiElement getElement() {
        ClsJavaCodeReferenceElementImpl clsJavaCodeReferenceElementImpl = this;
        if (clsJavaCodeReferenceElementImpl == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(24);
        }
        return clsJavaCodeReferenceElementImpl;
    }

    @Override
    public PsiType @NotNull [] getTypeParameters() {
        PsiType[] psiTypeArray = this.myRefParameterList == null ? PsiType.EMPTY_ARRAY : this.myRefParameterList.getTypeArguments();
        if (psiTypeArray == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(25);
        }
        return psiTypeArray;
    }

    @Override
    public boolean isQualified() {
        return false;
    }

    public PsiElement getQualifier() {
        return null;
    }

    public String toString() {
        return "PsiJavaCodeReferenceElement:" + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canonicalText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "advancedResolve";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 24: 
            case 25: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "advancedResolveImpl";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectOuterClassTypeArgs";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolveElement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processVariants";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "appendMirrorText";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setMirror";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Resolver
    implements ResolveCache.PolyVariantContextResolver<ClsJavaCodeReferenceElementImpl> {
        public static final Resolver INSTANCE = new Resolver();

        private Resolver() {
        }

        public JavaResolveResult @NotNull [] resolve(@NotNull ClsJavaCodeReferenceElementImpl ref, @NotNull PsiFile containingFile, boolean incompleteCode) {
            JavaResolveResult[] javaResolveResultArray;
            JavaResolveResult resolveResult;
            if (ref == null) {
                Resolver.$$$reportNull$$$0(0);
            }
            if (containingFile == null) {
                Resolver.$$$reportNull$$$0(1);
            }
            if ((resolveResult = ref.advancedResolveImpl(containingFile)) == null) {
                javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
            } else {
                JavaResolveResult[] javaResolveResultArray2 = new JavaResolveResult[1];
                javaResolveResultArray = javaResolveResultArray2;
                javaResolveResultArray2[0] = resolveResult;
            }
            if (javaResolveResultArray == null) {
                Resolver.$$$reportNull$$$0(2);
            }
            return javaResolveResultArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl$Resolver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl$Resolver";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

