/*
    SPDX-FileCopyrightText: 2010 Alex Richardson <alex.richardson@gmx.de>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#include "boolbitfielddatainformation.hpp"

// lib
#include <booldatainformation.hpp>
// libdatatypeeditors
#include <uintspinbox.hpp>
// KF
#include <KLocalizedString>
#include <KComboBox>
// Qt
#include <QScriptValue>


QString BoolBitfieldDataInformation::valueStringImpl() const
{
    Q_ASSERT(mWasAbleToRead);
    return BoolDataInformationMethods<quint64>::staticValueString(mValue.value<quint64>());
}

QVariant BoolBitfieldDataInformation::valueToQVariant() const
{
    Q_ASSERT(mWasAbleToRead);
    return BoolDataInformationMethods<quint64>::staticToQVariant(mValue.value<quint64>());
}

QString BoolBitfieldDataInformation::valueToQString(AllPrimitiveTypes value) const
{
    return BoolDataInformationMethods<quint64>::staticValueString(value.value<quint64>());
}

QVariant BoolBitfieldDataInformation::valueToQVariant(AllPrimitiveTypes value) const
{
    return BoolDataInformationMethods<quint64>::staticToQVariant(value.value<quint64>());
}

QWidget* BoolBitfieldDataInformation::createEditWidget(QWidget* parent) const
{
    if (width() == 1) {
        // just a simple combobox
        auto* const box = new KComboBox(false, parent);
        box->addItem(i18nc("boolean value", "false"));
        box->addItem(i18nc("boolean value", "true"));
        return box;
    }
    auto* const ret = new Okteta::UIntSpinBox(parent);
    ret->setBase(Kasten::StructureViewPreferences::unsignedDisplayBase());
    ret->setMaximum(mask());
    return ret;
}

QVariant BoolBitfieldDataInformation::dataFromWidget(const QWidget* w) const
{
    if (width() == 1) {
        const auto* const box = qobject_cast<const KComboBox*>(w);
        Q_CHECK_PTR(box);
        return box->currentIndex();
    }
    const auto* const spin = qobject_cast<const Okteta::UIntSpinBox*>(w);
    Q_CHECK_PTR(spin);
    if (spin) {
        return spin->value();
    }
    return {};
}

void BoolBitfieldDataInformation::setWidgetData(QWidget* w) const
{
    if (width() == 1) {
        auto* const box = qobject_cast<KComboBox*>(w);
        Q_CHECK_PTR(box);
        box->setCurrentIndex((mValue.value<quint64>() == 0) ? 0 : 1);
        return;
    }
    auto* const spin = qobject_cast<Okteta::UIntSpinBox*> (w);
    if (spin) {
        spin->setValue(mValue.value<quint64>());
    }
}

QScriptValue BoolBitfieldDataInformation::valueAsQScriptValue() const
{
    return (mValue.value<quint64>()) != 0;
}

QString BoolBitfieldDataInformation::typeNameImpl() const
{
    return i18ncp("Data type", "boolean bitfield (%1 bit wide)", "boolean bitfield (%1 bits wide)",
                  width());
}

AbstractBitfieldDataInformation::Type BoolBitfieldDataInformation::bitfieldType() const
{
    return AbstractBitfieldDataInformation::Type::Boolean;
}
