//
// lexis: Generates human-readable sequences from numeric values using a predefined word list
// examples/num2name.rs: Example to generate names using given numbers on the command line
//
// Copyright (c) 2024 Ali Polatel <alip@chesswob.org>
//
// SPDX-License-Identifier: GPL-3.0-or-later

use lexis::ToName;

fn main() {
    for num in std::env::args().skip(1) {
        let num = num.parse::<u64>().expect("invalid number");
        println!("{}", num.to_name());
    }
}
