/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.icons.converters;

import com.intellij.ui.TextIcon;
import com.intellij.util.ui.JBFont;
import com.jetbrains.rd.ide.model.AbstractColor;
import com.jetbrains.rd.ide.model.FontStyle;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.RectangleModel;
import com.jetbrains.rd.ide.model.TextBadgeIconModel;
import com.jetbrains.rd.platform.colors.ColorHostKt;
import com.jetbrains.rd.ui.icons.ProtocolIconConverter;
import com.jetbrains.rd.ui.icons.ProtocolIconModelRegistry;
import com.jetbrains.rd.ui.icons.ProtocolIconRegistry;
import com.jetbrains.rd.ui.icons.converters.TextBadgeIconConverterKt;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rd/ui/icons/converters/TextBadgeIconConverter;", "Lcom/jetbrains/rd/ui/icons/ProtocolIconConverter;", "Lcom/intellij/ui/TextIcon;", "Lcom/jetbrains/rd/ide/model/TextBadgeIconModel;", "<init>", "()V", "createIcon", "Ljavax/swing/Icon;", "model", "registry", "Lcom/jetbrains/rd/ui/icons/ProtocolIconRegistry;", "createModel", "Lcom/jetbrains/rd/ide/model/IconModel;", "icon", "Lcom/jetbrains/rd/ui/icons/ProtocolIconModelRegistry;", "intellij.rd.ui"})
public final class TextBadgeIconConverter
implements ProtocolIconConverter<TextIcon, TextBadgeIconModel> {
    @Nullable
    public Icon createIcon(@NotNull TextBadgeIconModel model, @NotNull ProtocolIconRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        AbstractColor abstractColor = model.getForeground();
        AbstractColor abstractColor2 = model.getBackground();
        AbstractColor abstractColor3 = model.getBorderColor();
        TextIcon icon = new TextIcon(model.getText(), abstractColor != null ? ColorHostKt.toColor((AbstractColor)abstractColor) : null, abstractColor2 != null ? ColorHostKt.toColor((AbstractColor)abstractColor2) : null, abstractColor3 != null ? ColorHostKt.toColor((AbstractColor)abstractColor3) : null, 0, model.getWithBorders());
        icon.setRound(model.getRound());
        icon.setInsets(model.getInsets().getY(), model.getInsets().getX(), model.getInsets().getHeight(), model.getInsets().getWidth());
        if (model.getFontSize() > 0.0f && model.getFontStyle() != null) {
            JBFont jBFont = JBFont.label();
            FontStyle fontStyle = model.getFontStyle();
            Intrinsics.checkNotNull((Object)fontStyle);
            icon.setFont((Font)jBFont.deriveFont(TextBadgeIconConverterKt.toStyle(fontStyle), model.getFontSize()));
        }
        if (model.getFontTransform() != null) {
            icon.setFontTransform(new AffineTransform(model.getFontTransform()));
        }
        return (Icon)icon;
    }

    @Nullable
    public IconModel createModel(@NotNull TextIcon icon, @NotNull ProtocolIconModelRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Font font = icon.getFont();
        float fontSize = font != null ? (float)font.getSize() : 0.0f;
        Font font2 = icon.getFont();
        FontStyle fontStyle = font2 != null ? TextBadgeIconConverterKt.toFontStyle(font2.getStyle()) : null;
        Font font3 = icon.getFont();
        int fontHash = font3 != null ? font3.hashCode() : 0;
        double[] transformArray = null;
        AffineTransform fontTransform = icon.getFontTransform();
        if (fontTransform != null) {
            transformArray = new double[6];
            fontTransform.getMatrix(transformArray);
        }
        Insets insets = icon.getInsets();
        String string = icon.getText();
        Integer n = icon.getRound();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getRound(...)");
        int n2 = ((Number)n).intValue();
        Boolean bl = icon.getWithBorders();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getWithBorders(...)");
        Color color = icon.getForeground();
        Color color2 = icon.getBackground();
        Color color3 = icon.getBorderColor();
        return (IconModel)new TextBadgeIconModel(string, fontSize, fontStyle, fontHash, transformArray, n2, bl.booleanValue(), (AbstractColor)(color != null ? ColorHostKt.toModel((Color)color) : null), (AbstractColor)(color2 != null ? ColorHostKt.toModel((Color)color2) : null), (AbstractColor)(color3 != null ? ColorHostKt.toModel((Color)color3) : null), new RectangleModel(insets.left, insets.top, insets.right, insets.bottom));
    }
}

