//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfsocket?language=objc)
#[repr(C)]
pub struct CFSocket {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFSocket {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFSocket"> for CFSocket {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfsocketerror?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFSocketError(pub CFIndex);
impl CFSocketError {
    #[doc(alias = "kCFSocketSuccess")]
    pub const Success: Self = Self(0);
    #[doc(alias = "kCFSocketError")]
    pub const Error: Self = Self(-1);
    #[doc(alias = "kCFSocketTimeout")]
    pub const Timeout: Self = Self(-2);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFSocketError {
    const ENCODING: Encoding = CFIndex::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFSocketError {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfsocketsignature?language=objc)
#[cfg(feature = "CFData")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFSocketSignature {
    pub protocolFamily: i32,
    pub socketType: i32,
    pub protocol: i32,
    pub address: *const CFData,
}

#[cfg(all(feature = "CFData", feature = "objc2"))]
unsafe impl Encode for CFSocketSignature {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <i32>::ENCODING,
            <i32>::ENCODING,
            <i32>::ENCODING,
            <*const CFData>::ENCODING,
        ],
    );
}

#[cfg(all(feature = "CFData", feature = "objc2"))]
unsafe impl RefEncode for CFSocketSignature {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfsocketcallbacktype?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFSocketCallBackType(pub CFOptionFlags);
bitflags::bitflags! {
    impl CFSocketCallBackType: CFOptionFlags {
        #[doc(alias = "kCFSocketNoCallBack")]
        const NoCallBack = 0;
        #[doc(alias = "kCFSocketReadCallBack")]
        const ReadCallBack = 1;
        #[doc(alias = "kCFSocketAcceptCallBack")]
        const AcceptCallBack = 2;
        #[doc(alias = "kCFSocketDataCallBack")]
        const DataCallBack = 3;
        #[doc(alias = "kCFSocketConnectCallBack")]
        const ConnectCallBack = 4;
        #[doc(alias = "kCFSocketWriteCallBack")]
        const WriteCallBack = 8;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFSocketCallBackType {
    const ENCODING: Encoding = CFOptionFlags::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFSocketCallBackType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfsocketautomaticallyreenablereadcallback?language=objc)
pub const kCFSocketAutomaticallyReenableReadCallBack: CFOptionFlags = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfsocketautomaticallyreenableacceptcallback?language=objc)
pub const kCFSocketAutomaticallyReenableAcceptCallBack: CFOptionFlags = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfsocketautomaticallyreenabledatacallback?language=objc)
pub const kCFSocketAutomaticallyReenableDataCallBack: CFOptionFlags = 3;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfsocketautomaticallyreenablewritecallback?language=objc)
pub const kCFSocketAutomaticallyReenableWriteCallBack: CFOptionFlags = 8;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfsocketleaveerrors?language=objc)
pub const kCFSocketLeaveErrors: CFOptionFlags = 64;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfsocketcloseoninvalidate?language=objc)
pub const kCFSocketCloseOnInvalidate: CFOptionFlags = 128;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfsocketcallback?language=objc)
#[cfg(feature = "CFData")]
pub type CFSocketCallBack = Option<
    unsafe extern "C-unwind" fn(
        *mut CFSocket,
        CFSocketCallBackType,
        *const CFData,
        *const c_void,
        *mut c_void,
    ),
>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfsocketcontext?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFSocketContext {
    pub version: CFIndex,
    pub info: *mut c_void,
    pub retain: Option<unsafe extern "C-unwind" fn(*const c_void) -> *const c_void>,
    pub release: Option<unsafe extern "C-unwind" fn(*const c_void)>,
    pub copyDescription: Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFSocketContext {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <CFIndex>::ENCODING,
            <*mut c_void>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*const c_void) -> *const c_void>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*const c_void)>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFSocketContext {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfsocketnativehandle?language=objc)
pub type CFSocketNativeHandle = c_int;

unsafe impl ConcreteType for CFSocket {
    #[doc(alias = "CFSocketGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFSocketGetTypeID() -> CFTypeID;
        }
        unsafe { CFSocketGetTypeID() }
    }
}

impl CFSocket {
    #[doc(alias = "CFSocketCreate")]
    #[cfg(feature = "CFData")]
    #[inline]
    pub unsafe fn new(
        allocator: Option<&CFAllocator>,
        protocol_family: i32,
        socket_type: i32,
        protocol: i32,
        call_back_types: CFOptionFlags,
        callout: CFSocketCallBack,
        context: *const CFSocketContext,
    ) -> Option<CFRetained<CFSocket>> {
        extern "C-unwind" {
            fn CFSocketCreate(
                allocator: Option<&CFAllocator>,
                protocol_family: i32,
                socket_type: i32,
                protocol: i32,
                call_back_types: CFOptionFlags,
                callout: CFSocketCallBack,
                context: *const CFSocketContext,
            ) -> Option<NonNull<CFSocket>>;
        }
        let ret = unsafe {
            CFSocketCreate(
                allocator,
                protocol_family,
                socket_type,
                protocol,
                call_back_types,
                callout,
                context,
            )
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFSocketCreateWithNative")]
    #[cfg(feature = "CFData")]
    #[inline]
    pub unsafe fn with_native(
        allocator: Option<&CFAllocator>,
        sock: CFSocketNativeHandle,
        call_back_types: CFOptionFlags,
        callout: CFSocketCallBack,
        context: *const CFSocketContext,
    ) -> Option<CFRetained<CFSocket>> {
        extern "C-unwind" {
            fn CFSocketCreateWithNative(
                allocator: Option<&CFAllocator>,
                sock: CFSocketNativeHandle,
                call_back_types: CFOptionFlags,
                callout: CFSocketCallBack,
                context: *const CFSocketContext,
            ) -> Option<NonNull<CFSocket>>;
        }
        let ret =
            unsafe { CFSocketCreateWithNative(allocator, sock, call_back_types, callout, context) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFSocketCreateWithSocketSignature")]
    #[cfg(feature = "CFData")]
    #[inline]
    pub unsafe fn with_socket_signature(
        allocator: Option<&CFAllocator>,
        signature: *const CFSocketSignature,
        call_back_types: CFOptionFlags,
        callout: CFSocketCallBack,
        context: *const CFSocketContext,
    ) -> Option<CFRetained<CFSocket>> {
        extern "C-unwind" {
            fn CFSocketCreateWithSocketSignature(
                allocator: Option<&CFAllocator>,
                signature: *const CFSocketSignature,
                call_back_types: CFOptionFlags,
                callout: CFSocketCallBack,
                context: *const CFSocketContext,
            ) -> Option<NonNull<CFSocket>>;
        }
        let ret = unsafe {
            CFSocketCreateWithSocketSignature(
                allocator,
                signature,
                call_back_types,
                callout,
                context,
            )
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFSocketCreateConnectedToSocketSignature")]
    #[cfg(all(feature = "CFData", feature = "CFDate"))]
    #[inline]
    pub unsafe fn new_connected_to_socket_signature(
        allocator: Option<&CFAllocator>,
        signature: *const CFSocketSignature,
        call_back_types: CFOptionFlags,
        callout: CFSocketCallBack,
        context: *const CFSocketContext,
        timeout: CFTimeInterval,
    ) -> Option<CFRetained<CFSocket>> {
        extern "C-unwind" {
            fn CFSocketCreateConnectedToSocketSignature(
                allocator: Option<&CFAllocator>,
                signature: *const CFSocketSignature,
                call_back_types: CFOptionFlags,
                callout: CFSocketCallBack,
                context: *const CFSocketContext,
                timeout: CFTimeInterval,
            ) -> Option<NonNull<CFSocket>>;
        }
        let ret = unsafe {
            CFSocketCreateConnectedToSocketSignature(
                allocator,
                signature,
                call_back_types,
                callout,
                context,
                timeout,
            )
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFSocketSetAddress")]
    #[cfg(feature = "CFData")]
    #[inline]
    pub fn set_address(self: &CFSocket, address: Option<&CFData>) -> CFSocketError {
        extern "C-unwind" {
            fn CFSocketSetAddress(s: &CFSocket, address: Option<&CFData>) -> CFSocketError;
        }
        unsafe { CFSocketSetAddress(self, address) }
    }

    #[doc(alias = "CFSocketConnectToAddress")]
    #[cfg(all(feature = "CFData", feature = "CFDate"))]
    #[inline]
    pub fn connect_to_address(
        self: &CFSocket,
        address: Option<&CFData>,
        timeout: CFTimeInterval,
    ) -> CFSocketError {
        extern "C-unwind" {
            fn CFSocketConnectToAddress(
                s: &CFSocket,
                address: Option<&CFData>,
                timeout: CFTimeInterval,
            ) -> CFSocketError;
        }
        unsafe { CFSocketConnectToAddress(self, address, timeout) }
    }

    #[doc(alias = "CFSocketInvalidate")]
    #[inline]
    pub fn invalidate(self: &CFSocket) {
        extern "C-unwind" {
            fn CFSocketInvalidate(s: &CFSocket);
        }
        unsafe { CFSocketInvalidate(self) }
    }

    #[doc(alias = "CFSocketIsValid")]
    #[inline]
    pub fn is_valid(self: &CFSocket) -> bool {
        extern "C-unwind" {
            fn CFSocketIsValid(s: &CFSocket) -> Boolean;
        }
        let ret = unsafe { CFSocketIsValid(self) };
        ret != 0
    }

    #[doc(alias = "CFSocketCopyAddress")]
    #[cfg(feature = "CFData")]
    #[inline]
    pub fn address(self: &CFSocket) -> Option<CFRetained<CFData>> {
        extern "C-unwind" {
            fn CFSocketCopyAddress(s: &CFSocket) -> Option<NonNull<CFData>>;
        }
        let ret = unsafe { CFSocketCopyAddress(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFSocketCopyPeerAddress")]
    #[cfg(feature = "CFData")]
    #[inline]
    pub fn peer_address(self: &CFSocket) -> Option<CFRetained<CFData>> {
        extern "C-unwind" {
            fn CFSocketCopyPeerAddress(s: &CFSocket) -> Option<NonNull<CFData>>;
        }
        let ret = unsafe { CFSocketCopyPeerAddress(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFSocketGetContext")]
    #[inline]
    pub unsafe fn context(self: &CFSocket, context: *mut CFSocketContext) {
        extern "C-unwind" {
            fn CFSocketGetContext(s: &CFSocket, context: *mut CFSocketContext);
        }
        unsafe { CFSocketGetContext(self, context) }
    }

    #[doc(alias = "CFSocketGetNative")]
    #[inline]
    pub fn native(self: &CFSocket) -> CFSocketNativeHandle {
        extern "C-unwind" {
            fn CFSocketGetNative(s: &CFSocket) -> CFSocketNativeHandle;
        }
        unsafe { CFSocketGetNative(self) }
    }

    #[doc(alias = "CFSocketCreateRunLoopSource")]
    #[cfg(feature = "CFRunLoop")]
    #[inline]
    pub fn new_run_loop_source(
        allocator: Option<&CFAllocator>,
        s: Option<&CFSocket>,
        order: CFIndex,
    ) -> Option<CFRetained<CFRunLoopSource>> {
        extern "C-unwind" {
            fn CFSocketCreateRunLoopSource(
                allocator: Option<&CFAllocator>,
                s: Option<&CFSocket>,
                order: CFIndex,
            ) -> Option<NonNull<CFRunLoopSource>>;
        }
        let ret = unsafe { CFSocketCreateRunLoopSource(allocator, s, order) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFSocketGetSocketFlags")]
    #[inline]
    pub fn socket_flags(self: &CFSocket) -> CFOptionFlags {
        extern "C-unwind" {
            fn CFSocketGetSocketFlags(s: &CFSocket) -> CFOptionFlags;
        }
        unsafe { CFSocketGetSocketFlags(self) }
    }

    #[doc(alias = "CFSocketSetSocketFlags")]
    #[inline]
    pub fn set_socket_flags(self: &CFSocket, flags: CFOptionFlags) {
        extern "C-unwind" {
            fn CFSocketSetSocketFlags(s: &CFSocket, flags: CFOptionFlags);
        }
        unsafe { CFSocketSetSocketFlags(self, flags) }
    }

    #[doc(alias = "CFSocketDisableCallBacks")]
    #[inline]
    pub fn disable_call_backs(self: &CFSocket, call_back_types: CFOptionFlags) {
        extern "C-unwind" {
            fn CFSocketDisableCallBacks(s: &CFSocket, call_back_types: CFOptionFlags);
        }
        unsafe { CFSocketDisableCallBacks(self, call_back_types) }
    }

    #[doc(alias = "CFSocketEnableCallBacks")]
    #[inline]
    pub fn enable_call_backs(self: &CFSocket, call_back_types: CFOptionFlags) {
        extern "C-unwind" {
            fn CFSocketEnableCallBacks(s: &CFSocket, call_back_types: CFOptionFlags);
        }
        unsafe { CFSocketEnableCallBacks(self, call_back_types) }
    }

    #[doc(alias = "CFSocketSendData")]
    #[cfg(all(feature = "CFData", feature = "CFDate"))]
    #[inline]
    pub fn send_data(
        self: &CFSocket,
        address: Option<&CFData>,
        data: Option<&CFData>,
        timeout: CFTimeInterval,
    ) -> CFSocketError {
        extern "C-unwind" {
            fn CFSocketSendData(
                s: &CFSocket,
                address: Option<&CFData>,
                data: Option<&CFData>,
                timeout: CFTimeInterval,
            ) -> CFSocketError;
        }
        unsafe { CFSocketSendData(self, address, data, timeout) }
    }

    #[doc(alias = "CFSocketRegisterValue")]
    #[cfg(all(feature = "CFData", feature = "CFDate"))]
    #[inline]
    pub unsafe fn register_value(
        name_server_signature: *const CFSocketSignature,
        timeout: CFTimeInterval,
        name: Option<&CFString>,
        value: Option<&CFPropertyList>,
    ) -> CFSocketError {
        extern "C-unwind" {
            fn CFSocketRegisterValue(
                name_server_signature: *const CFSocketSignature,
                timeout: CFTimeInterval,
                name: Option<&CFString>,
                value: Option<&CFPropertyList>,
            ) -> CFSocketError;
        }
        unsafe { CFSocketRegisterValue(name_server_signature, timeout, name, value) }
    }

    #[doc(alias = "CFSocketCopyRegisteredValue")]
    #[cfg(all(feature = "CFData", feature = "CFDate"))]
    #[inline]
    pub unsafe fn copy_registered_value(
        name_server_signature: *const CFSocketSignature,
        timeout: CFTimeInterval,
        name: Option<&CFString>,
        value: *mut *const CFPropertyList,
        name_server_address: *mut *const CFData,
    ) -> CFSocketError {
        extern "C-unwind" {
            fn CFSocketCopyRegisteredValue(
                name_server_signature: *const CFSocketSignature,
                timeout: CFTimeInterval,
                name: Option<&CFString>,
                value: *mut *const CFPropertyList,
                name_server_address: *mut *const CFData,
            ) -> CFSocketError;
        }
        unsafe {
            CFSocketCopyRegisteredValue(
                name_server_signature,
                timeout,
                name,
                value,
                name_server_address,
            )
        }
    }

    #[doc(alias = "CFSocketRegisterSocketSignature")]
    #[cfg(all(feature = "CFData", feature = "CFDate"))]
    #[inline]
    pub unsafe fn register_socket_signature(
        name_server_signature: *const CFSocketSignature,
        timeout: CFTimeInterval,
        name: Option<&CFString>,
        signature: *const CFSocketSignature,
    ) -> CFSocketError {
        extern "C-unwind" {
            fn CFSocketRegisterSocketSignature(
                name_server_signature: *const CFSocketSignature,
                timeout: CFTimeInterval,
                name: Option<&CFString>,
                signature: *const CFSocketSignature,
            ) -> CFSocketError;
        }
        unsafe { CFSocketRegisterSocketSignature(name_server_signature, timeout, name, signature) }
    }

    #[doc(alias = "CFSocketCopyRegisteredSocketSignature")]
    #[cfg(all(feature = "CFData", feature = "CFDate"))]
    #[inline]
    pub unsafe fn copy_registered_socket_signature(
        name_server_signature: *const CFSocketSignature,
        timeout: CFTimeInterval,
        name: Option<&CFString>,
        signature: *mut CFSocketSignature,
        name_server_address: *mut *const CFData,
    ) -> CFSocketError {
        extern "C-unwind" {
            fn CFSocketCopyRegisteredSocketSignature(
                name_server_signature: *const CFSocketSignature,
                timeout: CFTimeInterval,
                name: Option<&CFString>,
                signature: *mut CFSocketSignature,
                name_server_address: *mut *const CFData,
            ) -> CFSocketError;
        }
        unsafe {
            CFSocketCopyRegisteredSocketSignature(
                name_server_signature,
                timeout,
                name,
                signature,
                name_server_address,
            )
        }
    }

    #[doc(alias = "CFSocketUnregister")]
    #[cfg(all(feature = "CFData", feature = "CFDate"))]
    #[inline]
    pub unsafe fn unregister(
        name_server_signature: *const CFSocketSignature,
        timeout: CFTimeInterval,
        name: Option<&CFString>,
    ) -> CFSocketError {
        extern "C-unwind" {
            fn CFSocketUnregister(
                name_server_signature: *const CFSocketSignature,
                timeout: CFTimeInterval,
                name: Option<&CFString>,
            ) -> CFSocketError;
        }
        unsafe { CFSocketUnregister(name_server_signature, timeout, name) }
    }

    #[doc(alias = "CFSocketSetDefaultNameRegistryPortNumber")]
    #[inline]
    pub fn set_default_name_registry_port_number(port: u16) {
        extern "C-unwind" {
            fn CFSocketSetDefaultNameRegistryPortNumber(port: u16);
        }
        unsafe { CFSocketSetDefaultNameRegistryPortNumber(port) }
    }

    #[doc(alias = "CFSocketGetDefaultNameRegistryPortNumber")]
    #[inline]
    pub fn default_name_registry_port_number() -> u16 {
        extern "C-unwind" {
            fn CFSocketGetDefaultNameRegistryPortNumber() -> u16;
        }
        unsafe { CFSocketGetDefaultNameRegistryPortNumber() }
    }
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfsocketcommandkey?language=objc)
    pub static kCFSocketCommandKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfsocketnamekey?language=objc)
    pub static kCFSocketNameKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfsocketvaluekey?language=objc)
    pub static kCFSocketValueKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfsocketresultkey?language=objc)
    pub static kCFSocketResultKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfsocketerrorkey?language=objc)
    pub static kCFSocketErrorKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfsocketregistercommand?language=objc)
    pub static kCFSocketRegisterCommand: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfsocketretrievecommand?language=objc)
    pub static kCFSocketRetrieveCommand: Option<&'static CFString>;
}

#[cfg(feature = "CFData")]
#[deprecated = "renamed to `CFSocket::new`"]
#[inline]
pub unsafe extern "C-unwind" fn CFSocketCreate(
    allocator: Option<&CFAllocator>,
    protocol_family: i32,
    socket_type: i32,
    protocol: i32,
    call_back_types: CFOptionFlags,
    callout: CFSocketCallBack,
    context: *const CFSocketContext,
) -> Option<CFRetained<CFSocket>> {
    extern "C-unwind" {
        fn CFSocketCreate(
            allocator: Option<&CFAllocator>,
            protocol_family: i32,
            socket_type: i32,
            protocol: i32,
            call_back_types: CFOptionFlags,
            callout: CFSocketCallBack,
            context: *const CFSocketContext,
        ) -> Option<NonNull<CFSocket>>;
    }
    let ret = unsafe {
        CFSocketCreate(
            allocator,
            protocol_family,
            socket_type,
            protocol,
            call_back_types,
            callout,
            context,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFData")]
#[deprecated = "renamed to `CFSocket::with_native`"]
#[inline]
pub unsafe extern "C-unwind" fn CFSocketCreateWithNative(
    allocator: Option<&CFAllocator>,
    sock: CFSocketNativeHandle,
    call_back_types: CFOptionFlags,
    callout: CFSocketCallBack,
    context: *const CFSocketContext,
) -> Option<CFRetained<CFSocket>> {
    extern "C-unwind" {
        fn CFSocketCreateWithNative(
            allocator: Option<&CFAllocator>,
            sock: CFSocketNativeHandle,
            call_back_types: CFOptionFlags,
            callout: CFSocketCallBack,
            context: *const CFSocketContext,
        ) -> Option<NonNull<CFSocket>>;
    }
    let ret =
        unsafe { CFSocketCreateWithNative(allocator, sock, call_back_types, callout, context) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFData")]
#[deprecated = "renamed to `CFSocket::with_socket_signature`"]
#[inline]
pub unsafe extern "C-unwind" fn CFSocketCreateWithSocketSignature(
    allocator: Option<&CFAllocator>,
    signature: *const CFSocketSignature,
    call_back_types: CFOptionFlags,
    callout: CFSocketCallBack,
    context: *const CFSocketContext,
) -> Option<CFRetained<CFSocket>> {
    extern "C-unwind" {
        fn CFSocketCreateWithSocketSignature(
            allocator: Option<&CFAllocator>,
            signature: *const CFSocketSignature,
            call_back_types: CFOptionFlags,
            callout: CFSocketCallBack,
            context: *const CFSocketContext,
        ) -> Option<NonNull<CFSocket>>;
    }
    let ret = unsafe {
        CFSocketCreateWithSocketSignature(allocator, signature, call_back_types, callout, context)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFData", feature = "CFDate"))]
#[deprecated = "renamed to `CFSocket::new_connected_to_socket_signature`"]
#[inline]
pub unsafe extern "C-unwind" fn CFSocketCreateConnectedToSocketSignature(
    allocator: Option<&CFAllocator>,
    signature: *const CFSocketSignature,
    call_back_types: CFOptionFlags,
    callout: CFSocketCallBack,
    context: *const CFSocketContext,
    timeout: CFTimeInterval,
) -> Option<CFRetained<CFSocket>> {
    extern "C-unwind" {
        fn CFSocketCreateConnectedToSocketSignature(
            allocator: Option<&CFAllocator>,
            signature: *const CFSocketSignature,
            call_back_types: CFOptionFlags,
            callout: CFSocketCallBack,
            context: *const CFSocketContext,
            timeout: CFTimeInterval,
        ) -> Option<NonNull<CFSocket>>;
    }
    let ret = unsafe {
        CFSocketCreateConnectedToSocketSignature(
            allocator,
            signature,
            call_back_types,
            callout,
            context,
            timeout,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFData")]
#[deprecated = "renamed to `CFSocket::set_address`"]
#[inline]
pub extern "C-unwind" fn CFSocketSetAddress(
    s: &CFSocket,
    address: Option<&CFData>,
) -> CFSocketError {
    extern "C-unwind" {
        fn CFSocketSetAddress(s: &CFSocket, address: Option<&CFData>) -> CFSocketError;
    }
    unsafe { CFSocketSetAddress(s, address) }
}

#[cfg(all(feature = "CFData", feature = "CFDate"))]
#[deprecated = "renamed to `CFSocket::connect_to_address`"]
#[inline]
pub extern "C-unwind" fn CFSocketConnectToAddress(
    s: &CFSocket,
    address: Option<&CFData>,
    timeout: CFTimeInterval,
) -> CFSocketError {
    extern "C-unwind" {
        fn CFSocketConnectToAddress(
            s: &CFSocket,
            address: Option<&CFData>,
            timeout: CFTimeInterval,
        ) -> CFSocketError;
    }
    unsafe { CFSocketConnectToAddress(s, address, timeout) }
}

#[deprecated = "renamed to `CFSocket::invalidate`"]
#[inline]
pub extern "C-unwind" fn CFSocketInvalidate(s: &CFSocket) {
    extern "C-unwind" {
        fn CFSocketInvalidate(s: &CFSocket);
    }
    unsafe { CFSocketInvalidate(s) }
}

#[deprecated = "renamed to `CFSocket::is_valid`"]
#[inline]
pub extern "C-unwind" fn CFSocketIsValid(s: &CFSocket) -> bool {
    extern "C-unwind" {
        fn CFSocketIsValid(s: &CFSocket) -> Boolean;
    }
    let ret = unsafe { CFSocketIsValid(s) };
    ret != 0
}

#[cfg(feature = "CFData")]
#[deprecated = "renamed to `CFSocket::address`"]
#[inline]
pub extern "C-unwind" fn CFSocketCopyAddress(s: &CFSocket) -> Option<CFRetained<CFData>> {
    extern "C-unwind" {
        fn CFSocketCopyAddress(s: &CFSocket) -> Option<NonNull<CFData>>;
    }
    let ret = unsafe { CFSocketCopyAddress(s) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFData")]
#[deprecated = "renamed to `CFSocket::peer_address`"]
#[inline]
pub extern "C-unwind" fn CFSocketCopyPeerAddress(s: &CFSocket) -> Option<CFRetained<CFData>> {
    extern "C-unwind" {
        fn CFSocketCopyPeerAddress(s: &CFSocket) -> Option<NonNull<CFData>>;
    }
    let ret = unsafe { CFSocketCopyPeerAddress(s) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFSocket::context`"]
    pub fn CFSocketGetContext(s: &CFSocket, context: *mut CFSocketContext);
}

#[deprecated = "renamed to `CFSocket::native`"]
#[inline]
pub extern "C-unwind" fn CFSocketGetNative(s: &CFSocket) -> CFSocketNativeHandle {
    extern "C-unwind" {
        fn CFSocketGetNative(s: &CFSocket) -> CFSocketNativeHandle;
    }
    unsafe { CFSocketGetNative(s) }
}

#[cfg(feature = "CFRunLoop")]
#[deprecated = "renamed to `CFSocket::new_run_loop_source`"]
#[inline]
pub extern "C-unwind" fn CFSocketCreateRunLoopSource(
    allocator: Option<&CFAllocator>,
    s: Option<&CFSocket>,
    order: CFIndex,
) -> Option<CFRetained<CFRunLoopSource>> {
    extern "C-unwind" {
        fn CFSocketCreateRunLoopSource(
            allocator: Option<&CFAllocator>,
            s: Option<&CFSocket>,
            order: CFIndex,
        ) -> Option<NonNull<CFRunLoopSource>>;
    }
    let ret = unsafe { CFSocketCreateRunLoopSource(allocator, s, order) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFSocket::socket_flags`"]
#[inline]
pub extern "C-unwind" fn CFSocketGetSocketFlags(s: &CFSocket) -> CFOptionFlags {
    extern "C-unwind" {
        fn CFSocketGetSocketFlags(s: &CFSocket) -> CFOptionFlags;
    }
    unsafe { CFSocketGetSocketFlags(s) }
}

#[deprecated = "renamed to `CFSocket::set_socket_flags`"]
#[inline]
pub extern "C-unwind" fn CFSocketSetSocketFlags(s: &CFSocket, flags: CFOptionFlags) {
    extern "C-unwind" {
        fn CFSocketSetSocketFlags(s: &CFSocket, flags: CFOptionFlags);
    }
    unsafe { CFSocketSetSocketFlags(s, flags) }
}

#[deprecated = "renamed to `CFSocket::disable_call_backs`"]
#[inline]
pub extern "C-unwind" fn CFSocketDisableCallBacks(s: &CFSocket, call_back_types: CFOptionFlags) {
    extern "C-unwind" {
        fn CFSocketDisableCallBacks(s: &CFSocket, call_back_types: CFOptionFlags);
    }
    unsafe { CFSocketDisableCallBacks(s, call_back_types) }
}

#[deprecated = "renamed to `CFSocket::enable_call_backs`"]
#[inline]
pub extern "C-unwind" fn CFSocketEnableCallBacks(s: &CFSocket, call_back_types: CFOptionFlags) {
    extern "C-unwind" {
        fn CFSocketEnableCallBacks(s: &CFSocket, call_back_types: CFOptionFlags);
    }
    unsafe { CFSocketEnableCallBacks(s, call_back_types) }
}

#[cfg(all(feature = "CFData", feature = "CFDate"))]
#[deprecated = "renamed to `CFSocket::send_data`"]
#[inline]
pub extern "C-unwind" fn CFSocketSendData(
    s: &CFSocket,
    address: Option<&CFData>,
    data: Option<&CFData>,
    timeout: CFTimeInterval,
) -> CFSocketError {
    extern "C-unwind" {
        fn CFSocketSendData(
            s: &CFSocket,
            address: Option<&CFData>,
            data: Option<&CFData>,
            timeout: CFTimeInterval,
        ) -> CFSocketError;
    }
    unsafe { CFSocketSendData(s, address, data, timeout) }
}

extern "C-unwind" {
    #[cfg(all(feature = "CFData", feature = "CFDate"))]
    #[deprecated = "renamed to `CFSocket::register_value`"]
    pub fn CFSocketRegisterValue(
        name_server_signature: *const CFSocketSignature,
        timeout: CFTimeInterval,
        name: Option<&CFString>,
        value: Option<&CFPropertyList>,
    ) -> CFSocketError;
}

extern "C-unwind" {
    #[cfg(all(feature = "CFData", feature = "CFDate"))]
    #[deprecated = "renamed to `CFSocket::copy_registered_value`"]
    pub fn CFSocketCopyRegisteredValue(
        name_server_signature: *const CFSocketSignature,
        timeout: CFTimeInterval,
        name: Option<&CFString>,
        value: *mut *const CFPropertyList,
        name_server_address: *mut *const CFData,
    ) -> CFSocketError;
}

extern "C-unwind" {
    #[cfg(all(feature = "CFData", feature = "CFDate"))]
    #[deprecated = "renamed to `CFSocket::register_socket_signature`"]
    pub fn CFSocketRegisterSocketSignature(
        name_server_signature: *const CFSocketSignature,
        timeout: CFTimeInterval,
        name: Option<&CFString>,
        signature: *const CFSocketSignature,
    ) -> CFSocketError;
}

extern "C-unwind" {
    #[cfg(all(feature = "CFData", feature = "CFDate"))]
    #[deprecated = "renamed to `CFSocket::copy_registered_socket_signature`"]
    pub fn CFSocketCopyRegisteredSocketSignature(
        name_server_signature: *const CFSocketSignature,
        timeout: CFTimeInterval,
        name: Option<&CFString>,
        signature: *mut CFSocketSignature,
        name_server_address: *mut *const CFData,
    ) -> CFSocketError;
}

extern "C-unwind" {
    #[cfg(all(feature = "CFData", feature = "CFDate"))]
    #[deprecated = "renamed to `CFSocket::unregister`"]
    pub fn CFSocketUnregister(
        name_server_signature: *const CFSocketSignature,
        timeout: CFTimeInterval,
        name: Option<&CFString>,
    ) -> CFSocketError;
}

#[deprecated = "renamed to `CFSocket::set_default_name_registry_port_number`"]
#[inline]
pub extern "C-unwind" fn CFSocketSetDefaultNameRegistryPortNumber(port: u16) {
    extern "C-unwind" {
        fn CFSocketSetDefaultNameRegistryPortNumber(port: u16);
    }
    unsafe { CFSocketSetDefaultNameRegistryPortNumber(port) }
}

#[deprecated = "renamed to `CFSocket::default_name_registry_port_number`"]
#[inline]
pub extern "C-unwind" fn CFSocketGetDefaultNameRegistryPortNumber() -> u16 {
    extern "C-unwind" {
        fn CFSocketGetDefaultNameRegistryPortNumber() -> u16;
    }
    unsafe { CFSocketGetDefaultNameRegistryPortNumber() }
}
