from setuptools import setup


def read(fname):
    # makes sure that setup can be executed from a different location
    import os.path

    _here = os.path.abspath(os.path.dirname(__file__))
    return open(os.path.join(_here, fname)).read()


setup(
    name="pytest-localserver",
    author="Sebastian Rahlf",
    author_email="basti@redtoad.de",
    maintainer="David Zaslavsky",
    maintainer_email="diazona@ellipsix.net",
    license_files=["LICENSE"],
    license_expression="MIT",
    description="pytest plugin to test server connections locally.",
    long_description=read("README.rst"),
    url="https://github.com/pytest-dev/pytest-localserver",
    packages=["pytest_localserver"],
    python_requires=">=3.7",
    install_requires=["werkzeug>=0.10"],
    extras_require={
        "smtp": [
            "aiosmtpd",
        ],
    },
    tests_require=["pytest>=2.0.0", "requests"],
    entry_points={"pytest11": ["localserver = pytest_localserver.plugin"]},
    zip_safe=False,
    include_package_data=True,
    keywords="pytest server localhost http smtp",
    classifiers=[
        "Framework :: Pytest",
        "Operating System :: OS Independent",
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Programming Language :: Python :: 3.13",
        "Programming Language :: Python :: 3.14",
        "Topic :: Software Development :: Testing",
    ],
)
