/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	context "context"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	examplev1 "k8s.io/code-generator/examples/crd/apis/example/v1"
	applyconfigurationexamplev1 "k8s.io/code-generator/examples/crd/applyconfiguration/example/v1"
	scheme "k8s.io/code-generator/examples/crd/clientset/versioned/scheme"
)

// TestTypesGetter has a method to return a TestTypeInterface.
// A group's client should implement this interface.
type TestTypesGetter interface {
	TestTypes(namespace string) TestTypeInterface
}

// TestTypeInterface has methods to work with TestType resources.
type TestTypeInterface interface {
	Create(ctx context.Context, testType *examplev1.TestType, opts metav1.CreateOptions) (*examplev1.TestType, error)
	Update(ctx context.Context, testType *examplev1.TestType, opts metav1.UpdateOptions) (*examplev1.TestType, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, testType *examplev1.TestType, opts metav1.UpdateOptions) (*examplev1.TestType, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*examplev1.TestType, error)
	List(ctx context.Context, opts metav1.ListOptions) (*examplev1.TestTypeList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *examplev1.TestType, err error)
	Apply(ctx context.Context, testType *applyconfigurationexamplev1.TestTypeApplyConfiguration, opts metav1.ApplyOptions) (result *examplev1.TestType, err error)
	// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
	ApplyStatus(ctx context.Context, testType *applyconfigurationexamplev1.TestTypeApplyConfiguration, opts metav1.ApplyOptions) (result *examplev1.TestType, err error)
	GetClusterTestType(ctx context.Context, name string, opts metav1.GetOptions) (*examplev1.TestType, error)

	TestTypeExpansion
}

// testTypes implements TestTypeInterface
type testTypes struct {
	*gentype.ClientWithListAndApply[*examplev1.TestType, *examplev1.TestTypeList, *applyconfigurationexamplev1.TestTypeApplyConfiguration]
}

// newTestTypes returns a TestTypes
func newTestTypes(c *ExampleV1Client, namespace string) *testTypes {
	return &testTypes{
		gentype.NewClientWithListAndApply[*examplev1.TestType, *examplev1.TestTypeList, *applyconfigurationexamplev1.TestTypeApplyConfiguration](
			"testtypes",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *examplev1.TestType { return &examplev1.TestType{} },
			func() *examplev1.TestTypeList { return &examplev1.TestTypeList{} },
		),
	}
}

// GetClusterTestType takes name of the testType, and returns the corresponding testType object, and an error if there is any.
func (c *testTypes) GetClusterTestType(ctx context.Context, name string, options metav1.GetOptions) (result *examplev1.TestType, err error) {
	result = &examplev1.TestType{}
	err = c.GetClient().Get().
		Namespace(c.GetNamespace()).
		Resource("testtypes").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}
