/* Copyright 2021 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// ./test/core/br_table.wast

// ./test/core/br_table.wast:3
let $0 = instantiate(`(module
  ;; Auxiliary definition
  (func \$dummy)

  (func (export "type-i32")
    (block (drop (i32.ctz (br_table 0 0 (i32.const 0)))))
  )
  (func (export "type-i64")
    (block (drop (i64.ctz (br_table 0 0 (i32.const 0)))))
  )
  (func (export "type-f32")
    (block (drop (f32.neg (br_table 0 0 (i32.const 0)))))
  )
  (func (export "type-f64")
    (block (drop (f64.neg (br_table 0 0 (i32.const 0)))))
  )

  (func (export "type-i32-value") (result i32)
    (block (result i32) (i32.ctz (br_table 0 0 (i32.const 1) (i32.const 0))))
  )
  (func (export "type-i64-value") (result i64)
    (block (result i64) (i64.ctz (br_table 0 0 (i64.const 2) (i32.const 0))))
  )
  (func (export "type-f32-value") (result f32)
    (block (result f32) (f32.neg (br_table 0 0 (f32.const 3) (i32.const 0))))
  )
  (func (export "type-f64-value") (result f64)
    (block (result f64) (f64.neg (br_table 0 0 (f64.const 4) (i32.const 0))))
  )

  (func (export "empty") (param i32) (result i32)
    (block (br_table 0 (local.get 0)) (return (i32.const 21)))
    (i32.const 22)
  )
  (func (export "empty-value") (param i32) (result i32)
    (block (result i32)
      (br_table 0 (i32.const 33) (local.get 0)) (i32.const 31)
    )
  )

  (func (export "singleton") (param i32) (result i32)
    (block
      (block
        (br_table 1 0 (local.get 0))
        (return (i32.const 21))
      )
      (return (i32.const 20))
    )
    (i32.const 22)
  )

  (func (export "singleton-value") (param i32) (result i32)
    (block (result i32)
      (drop
        (block (result i32)
          (br_table 0 1 (i32.const 33) (local.get 0))
          (return (i32.const 31))
        )
      )
      (i32.const 32)
    )
  )

  (func (export "multiple") (param i32) (result i32)
    (block
      (block
        (block
          (block
            (block
              (br_table 3 2 1 0 4 (local.get 0))
              (return (i32.const 99))
            )
            (return (i32.const 100))
          )
          (return (i32.const 101))
        )
        (return (i32.const 102))
      )
      (return (i32.const 103))
    )
    (i32.const 104)
  )

  (func (export "multiple-value") (param i32) (result i32)
    (local i32)
    (local.set 1 (block (result i32)
      (local.set 1 (block (result i32)
        (local.set 1 (block (result i32)
          (local.set 1 (block (result i32)
            (local.set 1 (block (result i32)
              (br_table 3 2 1 0 4 (i32.const 200) (local.get 0))
              (return (i32.add (local.get 1) (i32.const 99)))
            ))
            (return (i32.add (local.get 1) (i32.const 10)))
          ))
          (return (i32.add (local.get 1) (i32.const 11)))
        ))
        (return (i32.add (local.get 1) (i32.const 12)))
      ))
      (return (i32.add (local.get 1) (i32.const 13)))
    ))
    (i32.add (local.get 1) (i32.const 14))
  )

  (func (export "large") (param i32) (result i32)
    (block
      (block
        (br_table
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
          (local.get 0)
        )
        (return (i32.const -1))
      )
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )

  (func (export "as-block-first")
    (block (br_table 0 0 0 (i32.const 0)) (call \$dummy))
  )
  (func (export "as-block-mid")
    (block (call \$dummy) (br_table 0 0 0 (i32.const 0)) (call \$dummy))
  )
  (func (export "as-block-last")
    (block (nop) (call \$dummy) (br_table 0 0 0 (i32.const 0)))
  )
  (func (export "as-block-value") (result i32)
    (block (result i32)
      (nop) (call \$dummy) (br_table 0 0 0 (i32.const 2) (i32.const 0))
    )
  )

  (func (export "as-loop-first") (result i32)
    (loop (result i32) (br_table 1 1 (i32.const 3) (i32.const 0)) (i32.const 1))
  )
  (func (export "as-loop-mid") (result i32)
    (loop (result i32)
      (call \$dummy)
      (br_table 1 1 1 (i32.const 4) (i32.const -1))
      (i32.const 2)
    )
  )
  (func (export "as-loop-last") (result i32)
    (loop (result i32)
      (nop) (call \$dummy) (br_table 1 1 1 (i32.const 5) (i32.const 1))
    )
  )

  (func (export "as-br-value") (result i32)
    (block (result i32) (br 0 (br_table 0 (i32.const 9) (i32.const 0))))
  )

  (func (export "as-br_if-cond")
    (block (br_if 0 (br_table 0 0 0 (i32.const 1))))
  )
  (func (export "as-br_if-value") (result i32)
    (block (result i32)
      (drop (br_if 0 (br_table 0 (i32.const 8) (i32.const 0)) (i32.const 1)))
      (i32.const 7)
    )
  )
  (func (export "as-br_if-value-cond") (result i32)
    (block (result i32)
      (drop (br_if 0 (i32.const 6) (br_table 0 0 (i32.const 9) (i32.const 0))))
      (i32.const 7)
    )
  )

  (func (export "as-br_table-index")
    (block (br_table 0 0 0 (br_table 0 (i32.const 1))))
  )
  (func (export "as-br_table-value") (result i32)
    (block (result i32)
      (br_table 0 0 0 (br_table 0 (i32.const 10) (i32.const 0)) (i32.const 1))
      (i32.const 7)
    )
  )
  (func (export "as-br_table-value-index") (result i32)
    (block (result i32)
      (br_table 0 0 (i32.const 6) (br_table 0 (i32.const 11) (i32.const 1)))
      (i32.const 7)
    )
  )

  (func (export "as-return-value") (result i64)
    (block (result i64) (return (br_table 0 (i64.const 7) (i32.const 0))))
  )

  (func (export "as-if-cond") (result i32)
    (block (result i32)
      (if (result i32)
        (br_table 0 (i32.const 2) (i32.const 0))
        (then (i32.const 0))
        (else (i32.const 1))
      )
    )
  )
  (func (export "as-if-then") (param i32 i32) (result i32)
    (block (result i32)
      (if (result i32)
        (local.get 0)
        (then (br_table 1 (i32.const 3) (i32.const 0)))
        (else (local.get 1))
      )
    )
  )
  (func (export "as-if-else") (param i32 i32) (result i32)
    (block (result i32)
      (if (result i32)
        (local.get 0)
        (then (local.get 1))
        (else (br_table 1 0 (i32.const 4) (i32.const 0)))
      )
    )
  )

  (func (export "as-select-first") (param i32 i32) (result i32)
    (block (result i32)
      (select
        (br_table 0 (i32.const 5) (i32.const 0)) (local.get 0) (local.get 1)
      )
    )
  )
  (func (export "as-select-second") (param i32 i32) (result i32)
    (block (result i32)
      (select
        (local.get 0) (br_table 0 (i32.const 6) (i32.const 1)) (local.get 1)
      )
    )
  )
  (func (export "as-select-cond") (result i32)
    (block (result i32)
      (select
        (i32.const 0) (i32.const 1) (br_table 0 (i32.const 7) (i32.const 1))
      )
    )
  )

  (func \$f (param i32 i32 i32) (result i32) (i32.const -1))
  (func (export "as-call-first") (result i32)
    (block (result i32)
      (call \$f
        (br_table 0 (i32.const 12) (i32.const 1)) (i32.const 2) (i32.const 3)
      )
    )
  )
  (func (export "as-call-mid") (result i32)
    (block (result i32)
      (call \$f
        (i32.const 1) (br_table 0 (i32.const 13) (i32.const 1)) (i32.const 3)
      )
    )
  )
  (func (export "as-call-last") (result i32)
    (block (result i32)
      (call \$f
        (i32.const 1) (i32.const 2) (br_table 0 (i32.const 14) (i32.const 1))
      )
    )
  )

  (type \$sig (func (param i32 i32 i32) (result i32)))
  (table funcref (elem \$f))
  (func (export "as-call_indirect-first") (result i32)
    (block (result i32)
      (call_indirect (type \$sig)
        (br_table 0 (i32.const 20) (i32.const 1)) (i32.const 1) (i32.const 2)
        (i32.const 3)
      )
    )
  )
  (func (export "as-call_indirect-mid") (result i32)
    (block (result i32)
      (call_indirect (type \$sig)
        (i32.const 0) (br_table 0 (i32.const 21) (i32.const 1)) (i32.const 2)
        (i32.const 3)
      )
    )
  )
  (func (export "as-call_indirect-last") (result i32)
    (block (result i32)
      (call_indirect (type \$sig)
        (i32.const 0) (i32.const 1) (br_table 0 (i32.const 22) (i32.const 1))
        (i32.const 3)
      )
    )
  )
  (func (export "as-call_indirect-func") (result i32)
    (block (result i32)
      (call_indirect (type \$sig)
        (i32.const 0) (i32.const 1) (i32.const 2)
        (br_table 0 (i32.const 23) (i32.const 1))
      )
    )
  )

  (func (export "as-local.set-value") (result i32)
    (local f32)
    (block (result i32)
      (local.set 0 (br_table 0 (i32.const 17) (i32.const 1)))
      (i32.const -1)
    )
  )
  (func (export "as-local.tee-value") (result i32)
    (local i32)
    (block (result i32)
      (local.set 0 (br_table 0 (i32.const 1) (i32.const 1)))
      (i32.const -1)
    )
  )
  (global \$a (mut i32) (i32.const 10))
  (func (export "as-global.set-value") (result i32)
    (block (result i32)
      (global.set \$a (br_table 0 (i32.const 1) (i32.const 1)))
      (i32.const -1)
    )
  )

  (memory 1)
  (func (export "as-load-address") (result f32)
    (block (result f32) (f32.load (br_table 0 (f32.const 1.7) (i32.const 1))))
  )
  (func (export "as-loadN-address") (result i64)
    (block (result i64) (i64.load8_s (br_table 0 (i64.const 30) (i32.const 1))))
  )

  (func (export "as-store-address") (result i32)
    (block (result i32)
      (f64.store (br_table 0 (i32.const 30) (i32.const 1)) (f64.const 7))
      (i32.const -1)
    )
  )
  (func (export "as-store-value") (result i32)
    (block (result i32)
      (i64.store (i32.const 2) (br_table 0 (i32.const 31) (i32.const 1)))
      (i32.const -1)
     )
  )

  (func (export "as-storeN-address") (result i32)
    (block (result i32)
      (i32.store8 (br_table 0 (i32.const 32) (i32.const 0)) (i32.const 7))
      (i32.const -1)
    )
  )
  (func (export "as-storeN-value") (result i32)
    (block (result i32)
      (i64.store16 (i32.const 2) (br_table 0 (i32.const 33) (i32.const 0)))
      (i32.const -1)
    )
  )

  (func (export "as-unary-operand") (result f32)
    (block (result f32) (f32.neg (br_table 0 (f32.const 3.4) (i32.const 0))))
  )

  (func (export "as-binary-left") (result i32)
    (block (result i32)
      (i32.add (br_table 0 0 (i32.const 3) (i32.const 0)) (i32.const 10))
    )
  )
  (func (export "as-binary-right") (result i64)
    (block (result i64)
      (i64.sub (i64.const 10) (br_table 0 (i64.const 45) (i32.const 0)))
    )
  )

  (func (export "as-test-operand") (result i32)
    (block (result i32) (i32.eqz (br_table 0 (i32.const 44) (i32.const 0))))
  )

  (func (export "as-compare-left") (result i32)
    (block (result i32)
      (f64.le (br_table 0 0 (i32.const 43) (i32.const 0)) (f64.const 10))
    )
  )
  (func (export "as-compare-right") (result i32)
    (block (result i32)
      (f32.ne (f32.const 10) (br_table 0 (i32.const 42) (i32.const 0)))
    )
  )

  (func (export "as-convert-operand") (result i32)
    (block (result i32)
      (i32.wrap_i64 (br_table 0 (i32.const 41) (i32.const 0)))
    )
  )

  (func (export "as-memory.grow-size") (result i32)
    (block (result i32) (memory.grow (br_table 0 (i32.const 40) (i32.const 0))))
  )

  (func (export "nested-block-value") (param i32) (result i32)
    (block (result i32)
      (drop (i32.const -1))
      (i32.add
        (i32.const 1)
        (block (result i32)
          (i32.add
            (i32.const 2)
            (block (result i32)
              (drop (i32.const 4))
              (i32.add
                (i32.const 8)
                (br_table 0 1 2 (i32.const 16) (local.get 0))
              )
            )
          )
        )
      )
    )
  )

  (func (export "nested-br-value") (param i32) (result i32)
    (block (result i32)
      (i32.add
        (i32.const 1)
        (block (result i32)
          (drop (i32.const 2))
          (drop
            (block (result i32)
              (drop (i32.const 4))
              (br 0 (br_table 2 1 0 (i32.const 8) (local.get 0)))
            )
          )
          (i32.const 16)
        )
      )
    )
  )

  (func (export "nested-br_if-value") (param i32) (result i32)
    (block (result i32)
      (i32.add
        (i32.const 1)
        (block (result i32)
          (drop (i32.const 2))
          (drop
            (block (result i32)
              (drop (i32.const 4))
              (drop
                (br_if 0
                  (br_table 0 1 2 (i32.const 8) (local.get 0))
                  (i32.const 1)
                )
              )
              (i32.const 32)
            )
          )
          (i32.const 16)
        )
      )
    )
  )

  (func (export "nested-br_if-value-cond") (param i32) (result i32)
    (block (result i32)
      (i32.add
        (i32.const 1)
        (block (result i32)
          (drop (i32.const 2))
          (drop
            (br_if 0 (i32.const 4) (br_table 0 1 0 (i32.const 8) (local.get 0)))
          )
          (i32.const 16)
        )
      )
    )
  )

  (func (export "nested-br_table-value") (param i32) (result i32)
    (block (result i32)
      (i32.add
        (i32.const 1)
        (block (result i32)
          (drop (i32.const 2))
          (drop
            (block (result i32)
              (drop (i32.const 4))
              (br_table 0 (br_table 0 1 2 (i32.const 8) (local.get 0)) (i32.const 1))
              (i32.const 32)
            )
          )
          (i32.const 16)
        )
      )
    )
  )

  (func (export "nested-br_table-value-index") (param i32) (result i32)
    (block (result i32)
      (i32.add
        (i32.const 1)
        (block (result i32)
          (drop (i32.const 2))
          (br_table 0 (i32.const 4) (br_table 0 1 0 (i32.const 8) (local.get 0)))
          (i32.const 16)
        )
      )
    )
  )

  (func (export "nested-br_table-loop-block") (param i32) (result i32)
    (local.set 0
      (loop (result i32)
        (block
          (br_table 1 0 0 (local.get 0))
        )
        (i32.const 0)
      )
    )
    (loop (result i32)
      (block
        (br_table 0 1 1 (local.get 0))
      )
      (i32.const 3)
    )
  )

  (func (export "meet-externref") (param i32) (param externref) (result externref)
    (block \$l1 (result externref)
      (block \$l2 (result externref)
        (br_table \$l1 \$l2 \$l1 (local.get 1) (local.get 0))
      )
    )
  )

  (func (export "meet-bottom")
    (block (result f64)
      (block (result f32)
        (unreachable)
        (br_table 0 1 1 (i32.const 1))
      )
      (drop)
      (f64.const 0)
    )
    (drop)
  )

  (type \$t (func))
  (func \$tf)
  (table \$t (ref null \$t) (elem \$tf))
  (func (export "meet-funcref-1") (param i32) (result (ref null func))
    (block \$l1 (result (ref null func))
      (block \$l2 (result (ref null \$t))
        (br_table \$l1 \$l1 \$l2 (table.get \$t (i32.const 0)) (local.get 0))
      )
    )
  )
  (func (export "meet-funcref-2") (param i32) (result (ref null func))
    (block \$l1 (result (ref null func))
      (block \$l2 (result (ref null \$t))
        (br_table \$l2 \$l2 \$l1 (table.get \$t (i32.const 0)) (local.get 0))
      )
    )
  )
  (func (export "meet-funcref-3") (param i32) (result (ref null func))
    (block \$l1 (result (ref null func))
      (block \$l2 (result (ref null \$t))
        (br_table \$l2 \$l1 \$l2 (table.get \$t (i32.const 0)) (local.get 0))
      )
    )
  )
  (func (export "meet-funcref-4") (param i32) (result (ref null func))
    (block \$l1 (result (ref null func))
      (block \$l2 (result (ref null \$t))
        (br_table \$l1 \$l2 \$l1 (table.get \$t (i32.const 0)) (local.get 0))
      )
    )
  )

  (func (export "meet-nullref") (param i32) (result (ref null func))
    (block \$l1 (result (ref null func))
      (block \$l2 (result (ref null \$t))
        (br_table \$l1 \$l2 \$l1 (ref.null \$t) (local.get 0))
      )
    )
  )

  (func (export "meet-multi-ref") (param i32) (result (ref null func))
    (block \$l1 (result (ref null func))
      (block \$l2 (result (ref null \$t))
        (block \$l3 (result (ref \$t))
          (br_table \$l3 \$l2 \$l1 (ref.func \$tf) (local.get 0))
        )
      )
    )
  )
)`);

// ./test/core/br_table.wast:1068
assert_return(() => invoke($0, `type-i32`, []), []);

// ./test/core/br_table.wast:1069
assert_return(() => invoke($0, `type-i64`, []), []);

// ./test/core/br_table.wast:1070
assert_return(() => invoke($0, `type-f32`, []), []);

// ./test/core/br_table.wast:1071
assert_return(() => invoke($0, `type-f64`, []), []);

// ./test/core/br_table.wast:1073
assert_return(() => invoke($0, `type-i32-value`, []), [value("i32", 1)]);

// ./test/core/br_table.wast:1074
assert_return(() => invoke($0, `type-i64-value`, []), [value("i64", 2n)]);

// ./test/core/br_table.wast:1075
assert_return(() => invoke($0, `type-f32-value`, []), [value("f32", 3)]);

// ./test/core/br_table.wast:1076
assert_return(() => invoke($0, `type-f64-value`, []), [value("f64", 4)]);

// ./test/core/br_table.wast:1078
assert_return(() => invoke($0, `empty`, [0]), [value("i32", 22)]);

// ./test/core/br_table.wast:1079
assert_return(() => invoke($0, `empty`, [1]), [value("i32", 22)]);

// ./test/core/br_table.wast:1080
assert_return(() => invoke($0, `empty`, [11]), [value("i32", 22)]);

// ./test/core/br_table.wast:1081
assert_return(() => invoke($0, `empty`, [-1]), [value("i32", 22)]);

// ./test/core/br_table.wast:1082
assert_return(() => invoke($0, `empty`, [-100]), [value("i32", 22)]);

// ./test/core/br_table.wast:1083
assert_return(() => invoke($0, `empty`, [-1]), [value("i32", 22)]);

// ./test/core/br_table.wast:1085
assert_return(() => invoke($0, `empty-value`, [0]), [value("i32", 33)]);

// ./test/core/br_table.wast:1086
assert_return(() => invoke($0, `empty-value`, [1]), [value("i32", 33)]);

// ./test/core/br_table.wast:1087
assert_return(() => invoke($0, `empty-value`, [11]), [value("i32", 33)]);

// ./test/core/br_table.wast:1088
assert_return(() => invoke($0, `empty-value`, [-1]), [value("i32", 33)]);

// ./test/core/br_table.wast:1089
assert_return(() => invoke($0, `empty-value`, [-100]), [value("i32", 33)]);

// ./test/core/br_table.wast:1090
assert_return(() => invoke($0, `empty-value`, [-1]), [value("i32", 33)]);

// ./test/core/br_table.wast:1092
assert_return(() => invoke($0, `singleton`, [0]), [value("i32", 22)]);

// ./test/core/br_table.wast:1093
assert_return(() => invoke($0, `singleton`, [1]), [value("i32", 20)]);

// ./test/core/br_table.wast:1094
assert_return(() => invoke($0, `singleton`, [11]), [value("i32", 20)]);

// ./test/core/br_table.wast:1095
assert_return(() => invoke($0, `singleton`, [-1]), [value("i32", 20)]);

// ./test/core/br_table.wast:1096
assert_return(() => invoke($0, `singleton`, [-100]), [value("i32", 20)]);

// ./test/core/br_table.wast:1097
assert_return(() => invoke($0, `singleton`, [-1]), [value("i32", 20)]);

// ./test/core/br_table.wast:1099
assert_return(() => invoke($0, `singleton-value`, [0]), [value("i32", 32)]);

// ./test/core/br_table.wast:1100
assert_return(() => invoke($0, `singleton-value`, [1]), [value("i32", 33)]);

// ./test/core/br_table.wast:1101
assert_return(() => invoke($0, `singleton-value`, [11]), [value("i32", 33)]);

// ./test/core/br_table.wast:1102
assert_return(() => invoke($0, `singleton-value`, [-1]), [value("i32", 33)]);

// ./test/core/br_table.wast:1103
assert_return(() => invoke($0, `singleton-value`, [-100]), [value("i32", 33)]);

// ./test/core/br_table.wast:1104
assert_return(() => invoke($0, `singleton-value`, [-1]), [value("i32", 33)]);

// ./test/core/br_table.wast:1106
assert_return(() => invoke($0, `multiple`, [0]), [value("i32", 103)]);

// ./test/core/br_table.wast:1107
assert_return(() => invoke($0, `multiple`, [1]), [value("i32", 102)]);

// ./test/core/br_table.wast:1108
assert_return(() => invoke($0, `multiple`, [2]), [value("i32", 101)]);

// ./test/core/br_table.wast:1109
assert_return(() => invoke($0, `multiple`, [3]), [value("i32", 100)]);

// ./test/core/br_table.wast:1110
assert_return(() => invoke($0, `multiple`, [4]), [value("i32", 104)]);

// ./test/core/br_table.wast:1111
assert_return(() => invoke($0, `multiple`, [5]), [value("i32", 104)]);

// ./test/core/br_table.wast:1112
assert_return(() => invoke($0, `multiple`, [6]), [value("i32", 104)]);

// ./test/core/br_table.wast:1113
assert_return(() => invoke($0, `multiple`, [10]), [value("i32", 104)]);

// ./test/core/br_table.wast:1114
assert_return(() => invoke($0, `multiple`, [-1]), [value("i32", 104)]);

// ./test/core/br_table.wast:1115
assert_return(() => invoke($0, `multiple`, [-1]), [value("i32", 104)]);

// ./test/core/br_table.wast:1117
assert_return(() => invoke($0, `multiple-value`, [0]), [value("i32", 213)]);

// ./test/core/br_table.wast:1118
assert_return(() => invoke($0, `multiple-value`, [1]), [value("i32", 212)]);

// ./test/core/br_table.wast:1119
assert_return(() => invoke($0, `multiple-value`, [2]), [value("i32", 211)]);

// ./test/core/br_table.wast:1120
assert_return(() => invoke($0, `multiple-value`, [3]), [value("i32", 210)]);

// ./test/core/br_table.wast:1121
assert_return(() => invoke($0, `multiple-value`, [4]), [value("i32", 214)]);

// ./test/core/br_table.wast:1122
assert_return(() => invoke($0, `multiple-value`, [5]), [value("i32", 214)]);

// ./test/core/br_table.wast:1123
assert_return(() => invoke($0, `multiple-value`, [6]), [value("i32", 214)]);

// ./test/core/br_table.wast:1124
assert_return(() => invoke($0, `multiple-value`, [10]), [value("i32", 214)]);

// ./test/core/br_table.wast:1125
assert_return(() => invoke($0, `multiple-value`, [-1]), [value("i32", 214)]);

// ./test/core/br_table.wast:1126
assert_return(() => invoke($0, `multiple-value`, [-1]), [value("i32", 214)]);

// ./test/core/br_table.wast:1128
assert_return(() => invoke($0, `large`, [0]), [value("i32", 0)]);

// ./test/core/br_table.wast:1129
assert_return(() => invoke($0, `large`, [1]), [value("i32", 1)]);

// ./test/core/br_table.wast:1130
assert_return(() => invoke($0, `large`, [100]), [value("i32", 0)]);

// ./test/core/br_table.wast:1131
assert_return(() => invoke($0, `large`, [101]), [value("i32", 1)]);

// ./test/core/br_table.wast:1132
assert_return(() => invoke($0, `large`, [10000]), [value("i32", 0)]);

// ./test/core/br_table.wast:1133
assert_return(() => invoke($0, `large`, [10001]), [value("i32", 1)]);

// ./test/core/br_table.wast:1134
assert_return(() => invoke($0, `large`, [1000000]), [value("i32", 1)]);

// ./test/core/br_table.wast:1135
assert_return(() => invoke($0, `large`, [1000001]), [value("i32", 1)]);

// ./test/core/br_table.wast:1137
assert_return(() => invoke($0, `as-block-first`, []), []);

// ./test/core/br_table.wast:1138
assert_return(() => invoke($0, `as-block-mid`, []), []);

// ./test/core/br_table.wast:1139
assert_return(() => invoke($0, `as-block-last`, []), []);

// ./test/core/br_table.wast:1140
assert_return(() => invoke($0, `as-block-value`, []), [value("i32", 2)]);

// ./test/core/br_table.wast:1142
assert_return(() => invoke($0, `as-loop-first`, []), [value("i32", 3)]);

// ./test/core/br_table.wast:1143
assert_return(() => invoke($0, `as-loop-mid`, []), [value("i32", 4)]);

// ./test/core/br_table.wast:1144
assert_return(() => invoke($0, `as-loop-last`, []), [value("i32", 5)]);

// ./test/core/br_table.wast:1146
assert_return(() => invoke($0, `as-br-value`, []), [value("i32", 9)]);

// ./test/core/br_table.wast:1148
assert_return(() => invoke($0, `as-br_if-cond`, []), []);

// ./test/core/br_table.wast:1149
assert_return(() => invoke($0, `as-br_if-value`, []), [value("i32", 8)]);

// ./test/core/br_table.wast:1150
assert_return(() => invoke($0, `as-br_if-value-cond`, []), [value("i32", 9)]);

// ./test/core/br_table.wast:1152
assert_return(() => invoke($0, `as-br_table-index`, []), []);

// ./test/core/br_table.wast:1153
assert_return(() => invoke($0, `as-br_table-value`, []), [value("i32", 10)]);

// ./test/core/br_table.wast:1154
assert_return(() => invoke($0, `as-br_table-value-index`, []), [value("i32", 11)]);

// ./test/core/br_table.wast:1156
assert_return(() => invoke($0, `as-return-value`, []), [value("i64", 7n)]);

// ./test/core/br_table.wast:1158
assert_return(() => invoke($0, `as-if-cond`, []), [value("i32", 2)]);

// ./test/core/br_table.wast:1159
assert_return(() => invoke($0, `as-if-then`, [1, 6]), [value("i32", 3)]);

// ./test/core/br_table.wast:1160
assert_return(() => invoke($0, `as-if-then`, [0, 6]), [value("i32", 6)]);

// ./test/core/br_table.wast:1161
assert_return(() => invoke($0, `as-if-else`, [0, 6]), [value("i32", 4)]);

// ./test/core/br_table.wast:1162
assert_return(() => invoke($0, `as-if-else`, [1, 6]), [value("i32", 6)]);

// ./test/core/br_table.wast:1164
assert_return(() => invoke($0, `as-select-first`, [0, 6]), [value("i32", 5)]);

// ./test/core/br_table.wast:1165
assert_return(() => invoke($0, `as-select-first`, [1, 6]), [value("i32", 5)]);

// ./test/core/br_table.wast:1166
assert_return(() => invoke($0, `as-select-second`, [0, 6]), [value("i32", 6)]);

// ./test/core/br_table.wast:1167
assert_return(() => invoke($0, `as-select-second`, [1, 6]), [value("i32", 6)]);

// ./test/core/br_table.wast:1168
assert_return(() => invoke($0, `as-select-cond`, []), [value("i32", 7)]);

// ./test/core/br_table.wast:1170
assert_return(() => invoke($0, `as-call-first`, []), [value("i32", 12)]);

// ./test/core/br_table.wast:1171
assert_return(() => invoke($0, `as-call-mid`, []), [value("i32", 13)]);

// ./test/core/br_table.wast:1172
assert_return(() => invoke($0, `as-call-last`, []), [value("i32", 14)]);

// ./test/core/br_table.wast:1174
assert_return(() => invoke($0, `as-call_indirect-first`, []), [value("i32", 20)]);

// ./test/core/br_table.wast:1175
assert_return(() => invoke($0, `as-call_indirect-mid`, []), [value("i32", 21)]);

// ./test/core/br_table.wast:1176
assert_return(() => invoke($0, `as-call_indirect-last`, []), [value("i32", 22)]);

// ./test/core/br_table.wast:1177
assert_return(() => invoke($0, `as-call_indirect-func`, []), [value("i32", 23)]);

// ./test/core/br_table.wast:1179
assert_return(() => invoke($0, `as-local.set-value`, []), [value("i32", 17)]);

// ./test/core/br_table.wast:1180
assert_return(() => invoke($0, `as-local.tee-value`, []), [value("i32", 1)]);

// ./test/core/br_table.wast:1181
assert_return(() => invoke($0, `as-global.set-value`, []), [value("i32", 1)]);

// ./test/core/br_table.wast:1183
assert_return(() => invoke($0, `as-load-address`, []), [value("f32", 1.7)]);

// ./test/core/br_table.wast:1184
assert_return(() => invoke($0, `as-loadN-address`, []), [value("i64", 30n)]);

// ./test/core/br_table.wast:1186
assert_return(() => invoke($0, `as-store-address`, []), [value("i32", 30)]);

// ./test/core/br_table.wast:1187
assert_return(() => invoke($0, `as-store-value`, []), [value("i32", 31)]);

// ./test/core/br_table.wast:1188
assert_return(() => invoke($0, `as-storeN-address`, []), [value("i32", 32)]);

// ./test/core/br_table.wast:1189
assert_return(() => invoke($0, `as-storeN-value`, []), [value("i32", 33)]);

// ./test/core/br_table.wast:1191
assert_return(() => invoke($0, `as-unary-operand`, []), [value("f32", 3.4)]);

// ./test/core/br_table.wast:1193
assert_return(() => invoke($0, `as-binary-left`, []), [value("i32", 3)]);

// ./test/core/br_table.wast:1194
assert_return(() => invoke($0, `as-binary-right`, []), [value("i64", 45n)]);

// ./test/core/br_table.wast:1196
assert_return(() => invoke($0, `as-test-operand`, []), [value("i32", 44)]);

// ./test/core/br_table.wast:1198
assert_return(() => invoke($0, `as-compare-left`, []), [value("i32", 43)]);

// ./test/core/br_table.wast:1199
assert_return(() => invoke($0, `as-compare-right`, []), [value("i32", 42)]);

// ./test/core/br_table.wast:1201
assert_return(() => invoke($0, `as-convert-operand`, []), [value("i32", 41)]);

// ./test/core/br_table.wast:1203
assert_return(() => invoke($0, `as-memory.grow-size`, []), [value("i32", 40)]);

// ./test/core/br_table.wast:1205
assert_return(() => invoke($0, `nested-block-value`, [0]), [value("i32", 19)]);

// ./test/core/br_table.wast:1206
assert_return(() => invoke($0, `nested-block-value`, [1]), [value("i32", 17)]);

// ./test/core/br_table.wast:1207
assert_return(() => invoke($0, `nested-block-value`, [2]), [value("i32", 16)]);

// ./test/core/br_table.wast:1208
assert_return(() => invoke($0, `nested-block-value`, [10]), [value("i32", 16)]);

// ./test/core/br_table.wast:1209
assert_return(() => invoke($0, `nested-block-value`, [-1]), [value("i32", 16)]);

// ./test/core/br_table.wast:1210
assert_return(() => invoke($0, `nested-block-value`, [100000]), [value("i32", 16)]);

// ./test/core/br_table.wast:1212
assert_return(() => invoke($0, `nested-br-value`, [0]), [value("i32", 8)]);

// ./test/core/br_table.wast:1213
assert_return(() => invoke($0, `nested-br-value`, [1]), [value("i32", 9)]);

// ./test/core/br_table.wast:1214
assert_return(() => invoke($0, `nested-br-value`, [2]), [value("i32", 17)]);

// ./test/core/br_table.wast:1215
assert_return(() => invoke($0, `nested-br-value`, [11]), [value("i32", 17)]);

// ./test/core/br_table.wast:1216
assert_return(() => invoke($0, `nested-br-value`, [-4]), [value("i32", 17)]);

// ./test/core/br_table.wast:1217
assert_return(() => invoke($0, `nested-br-value`, [10213210]), [value("i32", 17)]);

// ./test/core/br_table.wast:1219
assert_return(() => invoke($0, `nested-br_if-value`, [0]), [value("i32", 17)]);

// ./test/core/br_table.wast:1220
assert_return(() => invoke($0, `nested-br_if-value`, [1]), [value("i32", 9)]);

// ./test/core/br_table.wast:1221
assert_return(() => invoke($0, `nested-br_if-value`, [2]), [value("i32", 8)]);

// ./test/core/br_table.wast:1222
assert_return(() => invoke($0, `nested-br_if-value`, [9]), [value("i32", 8)]);

// ./test/core/br_table.wast:1223
assert_return(() => invoke($0, `nested-br_if-value`, [-9]), [value("i32", 8)]);

// ./test/core/br_table.wast:1224
assert_return(() => invoke($0, `nested-br_if-value`, [999999]), [value("i32", 8)]);

// ./test/core/br_table.wast:1226
assert_return(() => invoke($0, `nested-br_if-value-cond`, [0]), [value("i32", 9)]);

// ./test/core/br_table.wast:1227
assert_return(() => invoke($0, `nested-br_if-value-cond`, [1]), [value("i32", 8)]);

// ./test/core/br_table.wast:1228
assert_return(() => invoke($0, `nested-br_if-value-cond`, [2]), [value("i32", 9)]);

// ./test/core/br_table.wast:1229
assert_return(() => invoke($0, `nested-br_if-value-cond`, [3]), [value("i32", 9)]);

// ./test/core/br_table.wast:1230
assert_return(() => invoke($0, `nested-br_if-value-cond`, [-1000000]), [value("i32", 9)]);

// ./test/core/br_table.wast:1231
assert_return(() => invoke($0, `nested-br_if-value-cond`, [9423975]), [value("i32", 9)]);

// ./test/core/br_table.wast:1233
assert_return(() => invoke($0, `nested-br_table-value`, [0]), [value("i32", 17)]);

// ./test/core/br_table.wast:1234
assert_return(() => invoke($0, `nested-br_table-value`, [1]), [value("i32", 9)]);

// ./test/core/br_table.wast:1235
assert_return(() => invoke($0, `nested-br_table-value`, [2]), [value("i32", 8)]);

// ./test/core/br_table.wast:1236
assert_return(() => invoke($0, `nested-br_table-value`, [9]), [value("i32", 8)]);

// ./test/core/br_table.wast:1237
assert_return(() => invoke($0, `nested-br_table-value`, [-9]), [value("i32", 8)]);

// ./test/core/br_table.wast:1238
assert_return(() => invoke($0, `nested-br_table-value`, [999999]), [value("i32", 8)]);

// ./test/core/br_table.wast:1240
assert_return(() => invoke($0, `nested-br_table-value-index`, [0]), [value("i32", 9)]);

// ./test/core/br_table.wast:1241
assert_return(() => invoke($0, `nested-br_table-value-index`, [1]), [value("i32", 8)]);

// ./test/core/br_table.wast:1242
assert_return(() => invoke($0, `nested-br_table-value-index`, [2]), [value("i32", 9)]);

// ./test/core/br_table.wast:1243
assert_return(() => invoke($0, `nested-br_table-value-index`, [3]), [value("i32", 9)]);

// ./test/core/br_table.wast:1244
assert_return(() => invoke($0, `nested-br_table-value-index`, [-1000000]), [value("i32", 9)]);

// ./test/core/br_table.wast:1245
assert_return(() => invoke($0, `nested-br_table-value-index`, [9423975]), [value("i32", 9)]);

// ./test/core/br_table.wast:1247
assert_return(() => invoke($0, `nested-br_table-loop-block`, [1]), [value("i32", 3)]);

// ./test/core/br_table.wast:1249
assert_return(() => invoke($0, `meet-externref`, [0, externref(1)]), [new ExternRefResult(1)]);

// ./test/core/br_table.wast:1250
assert_return(() => invoke($0, `meet-externref`, [1, externref(1)]), [new ExternRefResult(1)]);

// ./test/core/br_table.wast:1251
assert_return(() => invoke($0, `meet-externref`, [2, externref(1)]), [new ExternRefResult(1)]);

// ./test/core/br_table.wast:1253
assert_return(() => invoke($0, `meet-funcref-1`, [0]), [new RefWithType('funcref')]);

// ./test/core/br_table.wast:1254
assert_return(() => invoke($0, `meet-funcref-1`, [1]), [new RefWithType('funcref')]);

// ./test/core/br_table.wast:1255
assert_return(() => invoke($0, `meet-funcref-1`, [2]), [new RefWithType('funcref')]);

// ./test/core/br_table.wast:1256
assert_return(() => invoke($0, `meet-funcref-2`, [0]), [new RefWithType('funcref')]);

// ./test/core/br_table.wast:1257
assert_return(() => invoke($0, `meet-funcref-2`, [1]), [new RefWithType('funcref')]);

// ./test/core/br_table.wast:1258
assert_return(() => invoke($0, `meet-funcref-2`, [2]), [new RefWithType('funcref')]);

// ./test/core/br_table.wast:1259
assert_return(() => invoke($0, `meet-funcref-3`, [0]), [new RefWithType('funcref')]);

// ./test/core/br_table.wast:1260
assert_return(() => invoke($0, `meet-funcref-3`, [1]), [new RefWithType('funcref')]);

// ./test/core/br_table.wast:1261
assert_return(() => invoke($0, `meet-funcref-3`, [2]), [new RefWithType('funcref')]);

// ./test/core/br_table.wast:1262
assert_return(() => invoke($0, `meet-funcref-4`, [0]), [new RefWithType('funcref')]);

// ./test/core/br_table.wast:1263
assert_return(() => invoke($0, `meet-funcref-4`, [1]), [new RefWithType('funcref')]);

// ./test/core/br_table.wast:1264
assert_return(() => invoke($0, `meet-funcref-4`, [2]), [new RefWithType('funcref')]);

// ./test/core/br_table.wast:1266
assert_invalid(
  () => instantiate(`(module (func \$type-arg-void-vs-num (result i32)
    (block (br_table 0 (i32.const 1)) (i32.const 1))
  ))`),
  `type mismatch`,
);

// ./test/core/br_table.wast:1273
assert_invalid(
  () => instantiate(`(module (func \$type-arg-empty-vs-num (result i32)
    (block (br_table 0) (i32.const 1))
  ))`),
  `type mismatch`,
);

// ./test/core/br_table.wast:1280
assert_invalid(
  () => instantiate(`(module (func \$type-arg-void-vs-num (result i32)
    (block (result i32) (br_table 0 (nop) (i32.const 1)) (i32.const 1))
  ))`),
  `type mismatch`,
);

// ./test/core/br_table.wast:1286
assert_invalid(
  () => instantiate(`(module (func \$type-arg-num-vs-num (result i32)
    (block (result i32)
      (br_table 0 0 0 (i64.const 1) (i32.const 1)) (i32.const 1)
    )
  ))`),
  `type mismatch`,
);

// ./test/core/br_table.wast:1294
assert_invalid(
  () => instantiate(`(module (func \$type-arg-num-vs-arg-num
    (block
      (block (result f32)
        (br_table 0 1 (f32.const 0) (i32.const 0))
      )
      (drop)
    )
  ))`),
  `type mismatch`,
);

// ./test/core/br_table.wast:1305
assert_invalid(
  () => instantiate(`(module (func
    (block (result i32)
      (block (result i64)
        (br_table 0 1 (i32.const 0) (i32.const 0))
      )
    )
  ))`),
  `type mismatch`,
);

// ./test/core/br_table.wast:1316
assert_invalid(
  () => instantiate(`(module (func \$type-index-void-vs-i32
    (block (br_table 0 0 0 (nop)))
  ))`),
  `type mismatch`,
);

// ./test/core/br_table.wast:1322
assert_invalid(
  () => instantiate(`(module (func \$type-index-num-vs-i32
    (block (br_table 0 (i64.const 0)))
  ))`),
  `type mismatch`,
);

// ./test/core/br_table.wast:1328
assert_invalid(
  () => instantiate(`(module (func \$type-arg-index-void-vs-i32 (result i32)
    (block (result i32) (br_table 0 0 (i32.const 0) (nop)) (i32.const 1))
  ))`),
  `type mismatch`,
);

// ./test/core/br_table.wast:1334
assert_invalid(
  () => instantiate(`(module (func \$type-arg-void-vs-num-nested (result i32)
    (block (result i32) (i32.const 0) (block (br_table 1 (i32.const 0))))
  ))`),
  `type mismatch`,
);

// ./test/core/br_table.wast:1340
assert_invalid(
  () => instantiate(`(module (func \$type-arg-index-num-vs-i32 (result i32)
    (block (result i32)
      (br_table 0 0 (i32.const 0) (i64.const 0)) (i32.const 1)
    )
  ))`),
  `type mismatch`,
);

// ./test/core/br_table.wast:1349
assert_invalid(
  () => instantiate(`(module (func \$type-arg-void-vs-num (result i32)
    (block (br_table 0 (i32.const 1)) (i32.const 1))
  ))`),
  `type mismatch`,
);

// ./test/core/br_table.wast:1356
assert_invalid(
  () => instantiate(`(module
    (func \$type-arg-index-empty-in-then
      (block
        (i32.const 0) (i32.const 0)
        (if (result i32) (then (br_table 0)))
      )
      (i32.eqz) (drop)
    )
  )`),
  `type mismatch`,
);

// ./test/core/br_table.wast:1368
assert_invalid(
  () => instantiate(`(module
    (func \$type-arg-value-empty-in-then
      (block
        (i32.const 0) (i32.const 0)
        (if (result i32) (then (br_table 0 (i32.const 1))))
      )
      (i32.eqz) (drop)
    )
  )`),
  `type mismatch`,
);

// ./test/core/br_table.wast:1380
assert_invalid(
  () => instantiate(`(module
    (func \$type-arg-index-empty-in-return
      (block (result i32)
        (return (br_table 0))
      )
      (i32.eqz) (drop)
    )
  )`),
  `type mismatch`,
);

// ./test/core/br_table.wast:1391
assert_invalid(
  () => instantiate(`(module
    (func \$type-arg-value-empty-in-return
      (block (result i32)
        (return (br_table 0 (i32.const 1)))
      )
      (i32.eqz) (drop)
    )
  )`),
  `type mismatch`,
);

// ./test/core/br_table.wast:1403
assert_invalid(
  () => instantiate(`(module
    (func (param i32) (result i32)
      (loop (result i32)
        (block (result i32)
          (br_table 0 1 (i32.const 1) (local.get 0))
        )
      )
    )
  )`),
  `type mismatch`,
);

// ./test/core/br_table.wast:1415
assert_invalid(
  () => instantiate(`(module
    (func (param i32) (result i32)
      (block (result i32)
        (loop (result i32)
          (br_table 0 1 (i32.const 1) (local.get 0))
        )
      )
    )
  )`),
  `type mismatch`,
);

// ./test/core/br_table.wast:1429
assert_invalid(
  () => instantiate(`(module (func \$unbound-label
    (block (br_table 2 1 (i32.const 1)))
  ))`),
  `unknown label`,
);

// ./test/core/br_table.wast:1435
assert_invalid(
  () => instantiate(`(module (func \$unbound-nested-label
    (block (block (br_table 0 5 (i32.const 1))))
  ))`),
  `unknown label`,
);

// ./test/core/br_table.wast:1441
assert_invalid(
  () => instantiate(`(module (func \$large-label
    (block (br_table 0 0x10000001 0 (i32.const 1)))
  ))`),
  `unknown label`,
);

// ./test/core/br_table.wast:1448
assert_invalid(
  () => instantiate(`(module (func \$unbound-label-default
    (block (br_table 1 2 (i32.const 1)))
  ))`),
  `unknown label`,
);

// ./test/core/br_table.wast:1454
assert_invalid(
  () => instantiate(`(module (func \$unbound-nested-label-default
    (block (block (br_table 0 5 (i32.const 1))))
  ))`),
  `unknown label`,
);

// ./test/core/br_table.wast:1460
assert_invalid(
  () => instantiate(`(module (func \$large-label-default
    (block (br_table 0 0 0x10000001 (i32.const 1)))
  ))`),
  `unknown label`,
);
